from bs4 import BeautifulSoup
import requests
# Here, we're just importing both Beautiful Soup and the Requests library
page_link = 'https://weather.com/weather/tenday/l/New+York+NY+USNY0996:1:US'
# this is the url that we've already determined is safe and legal to scrape from.
page_response = requests.get(page_link, timeout=5)
# here, we fetch the content from the url, using the requests library
soup = BeautifulSoup(page_response.content, "html.parser")
#we use the html parser to parse the url content and store it in a variable.

# print(soup.prettify())

print(soup.title)


# getting the top two temperatures and getting their descriptions using find through class
get_temps = soup.find_all('span', class_="DailyContent--temp--1s3a7")[:2]
get_desc = soup.find_all('p', class_="DailyContent--narrative--3Ti6_")[:2]
for i in range(2):
	print(get_temps[i].get_text())
	print(get_desc[i].get_text())


# getting the top two temperatures using select through CSS selector
get_temp1 = soup.select('#detailIndex0 > div > div:nth-child(1) > div > div:nth-child(1) > span')
get_temp2 = soup.select('#detailIndex0 > div > div:nth-child(3) > div > div:nth-child(1) > span')
print(get_temp1[0].get_text())
print(get_temp2[0].get_text())











